package com.touchlock;

import android.app.Activity;
import android.os.Bundle;
import android.util.DisplayMetrics;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;

public class MainActivity extends Activity {	

	private OverlayDialog mOverlayDialog;
	
	@Override
	protected void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		setContentView(R.layout.main);
		setUpLockShape();
		
		mOverlayDialog = new OverlayDialog(this);
		mOverlayDialog.show();
	}

	private void setUpLockShape() {
		ImageView lock = (ImageView) findViewById(R.id.lock);
		View lockShape = findViewById(R.id.lockshape);
		View lockShapeParent = (View) lockShape.getParent();
		
		int visibleWidth = getResources().getDrawable(R.drawable.lock_open_w).getIntrinsicWidth();
		
		DisplayMetrics displaymetrics = getResources().getDisplayMetrics();
		int width = displaymetrics.widthPixels / 2 + visibleWidth / 2;
		int radiusPx = getResources().getDimensionPixelSize(R.dimen.radius);
		
		ViewGroup.LayoutParams vlp = lockShapeParent.getLayoutParams();
		vlp.width = width;
		lockShapeParent.setLayoutParams(vlp);
		lockShapeParent.setBackgroundResource(0);
		
		LinearLayout.LayoutParams llp = (LinearLayout.LayoutParams) lockShape.getLayoutParams();
		llp.width = width;
		llp.leftMargin = 0 - width + visibleWidth + radiusPx;
		lockShape.setLayoutParams(llp);
		lockShape.setOnTouchListener(new UnlockTouchListener(llp, lock, lockShapeParent));
	}

	@Override
	protected void onDestroy() {
		super.onDestroy();
		mOverlayDialog.dismiss();
		mOverlayDialog = null;
	}
}
