package de.mre.colorpal;

import java.io.File;
import java.io.PrintWriter;

/**
 * Created by jarny on 07.10.2016.
 */
public class Calc
{
  float beginHeight = 300.0f;
  float endHeight = 880.0f;

  int steps = 50;
  float beginHue = 0.1f;
  float endHue = 0.9f;


  float height = beginHeight;
  float hue = beginHue;
  float saturation = 1.0f;
  float value = 1.0f;

  float dHue = (endHue - beginHue) / steps;
  float dSaturation = 0.0f;
  float dValue = 0.0f;

  float dHeight = (endHeight - beginHeight) / steps;


  public static void main(String[] args)
  {
    Calc app = new Calc();
    app.run();
  }

  public void run()
  {
    File file = new File("jarny.cpt");
    PrintWriter pw = null;
    try
    {
      pw = new PrintWriter(file);

      pw.print("# created by Jarny\n#\n");
      pw.print("# minHeight:" + beginHeight + " maxHeight:" + endHeight + "\n");
      pw.print("# minHue:" + beginHue + " maxHue:" + endHue + "\n");
      pw.print("# steps:" + steps + "\n\n");
      pw.print("# COLOR_MODEL = RGB \n\n");
      for (int i = 0; i < steps - 0; i++)
      {
        int h = (int) height;
        pw.print("" + h + "\t" + hsvToRgb(hue, saturation, value));

        height += dHeight;

        h = (int) height;

        // contour lines
        pw.println("\t" + (h-3) + "\t" + hsvToRgb(hue, saturation, value));
        pw.print("" + (h-2) + "\t" + hsvToRgb(hue, saturation, value/1.5f)); // make contours darker
        // contour lines end
        pw.println("\t" + (h-1) + "\t" + hsvToRgb(hue, saturation, value));

        hue += dHue;
        saturation += dSaturation;
        value += dValue;
      }

      pw.print("B\t255\t255\t255\n");
      pw.print("F\t0\t0\t0\n");
      pw.print("N\t255\t0\t0\n");
    }
    catch(Exception e)
    {
      e.printStackTrace();
    }
    finally
    {
      pw.close();
    }
  }


  public String hsvToRgb(float hue, float saturation, float value)
  {
    int h = (int) (hue * 6);
    float f = hue * 6 - h;
    float p = value * (1 - saturation);
    float q = value * (1 - f * saturation);
    float t = value * (1 - (1 - f) * saturation);

    switch (h)
    {
      case 0:
        return rgbToString(value, t, p);
      case 1:
        return rgbToString(q, value, p);
      case 2:
        return rgbToString(p, value, t);
      case 3:
        return rgbToString(p, q, value);
      case 4:
        return rgbToString(t, p, value);
      case 5:
        return rgbToString(value, p, q);
      default:
        throw new RuntimeException("Something went wrong when converting from HSV to RGB. Input was " + hue + ", " + saturation + ", " + value);
    }
  }

  private String rgbToString(float r, float g, float b)
  {
    int red = (int)(r * 255);
    int green = (int)(g * 255);
    int blue = (int)(b * 255);

    return String.valueOf(red) + "\t" + String.valueOf(green) + "\t" + String.valueOf(blue) + "\t";
  }
}
